import cv2
import numpy as np

cap = cv2.VideoCapture(0)  # initialize the camera

while True:
    _, frame = cap.read()  # read a frame from the camera
    frame = cv2.resize(frame, (640, 480))  # resize the frame

    # apply color thresholding to detect white and yellow lanes
    hsv = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)
    lower_white = np.array([0, 0, 200])
    upper_white = np.array([180, 30, 255])
    mask_white = cv2.inRange(hsv, lower_white, upper_white)
    lower_yellow = np.array([15, 50, 50])
    upper_yellow = np.array([30, 255, 255])
    mask_yellow = cv2.inRange(hsv, lower_yellow, upper_yellow)
    mask = cv2.bitwise_or(mask_white, mask_yellow)

    # apply Gaussian blur to reduce noise
    blur = cv2.GaussianBlur(mask, (5, 5), 0)

    # apply Canny edge detection to detect edges
    edges = cv2.Canny(blur, 50, 150)

    # apply a region of interest mask to focus on the road lanes
    mask = np.zeros_like(edges)
    mask_color = (255, 255, 255)
    vertices = np.array([[(0, 480), (320, 240), (320, 240), (640, 480)]], dtype=np.int32)
    cv2.fillPoly(mask, vertices, mask_color)
    masked_edges = cv2.bitwise_and(edges, mask)

    # apply Hough line detection to detect lane lines
    rho = 1
    theta = np.pi / 180
    threshold = 15
    min_line_length = 30
    max_line_gap = 10
    lines = cv2.HoughLinesP(masked_edges, rho, theta, threshold, np.array([]), min_line_length, max_line_gap)

    # draw the lane lines on the original frame
    line_color = (0, 0, 255)
    line_thickness = 3
    if lines is not None:
        for line in lines:
            x1, y1, x2, y2 = line[0]
            cv2.line(frame, (x1, y1), (x2, y2), line_color, line_thickness)

    # display the resulting frame
    cv2.imshow('frame', frame)

    # exit the loop when 'q' is pressed
    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

# release the camera and close all windows
cap.release()
cv2.destroyAllWindows()
